﻿#target aftereffects

// animationPATTERNS v1.2
// Markus Bergelt 2012 
function mb_animationPatterns(thisObj) {
    var versionNr = "v1.2";

    // Variablen für Palette ######################################################################
    var dimsAniPatternsList = [0,0,140,20];
    //var aryAniPatternsList = readPatternsInLayer();
    var aryAniPatternsList = ["- AE default -"];
    var dimsStaticText = [0,0,140,5];
    var dimsCUBtn = [0,0,45,55];
    var dimsFindOutBtn = dimsAniPatternsList - [0,0,110,-5];
    var dimsApplyBtn = dimsAniPatternsList - [0,0,40,-5];
    var dimsHelpBtn = [0,0,20,20];

    var createPalette = function(thisObj, typeOfWindow, windowSize) {
            var palette = (thisObj instanceof Panel) ? thisObj : new Window(typeOfWindow, "animationPATTERNS", windowSize, {resizeable: true});
            return palette;
            }
         
    // Hilfedialog ###########################################################################################
    var helpMeOutDlg = function(thisObj){
        var helpTextAry = [];
        for(i=0; i<5; ++i){
            helpTextAry.push("can't load file\ranimationPATTERNS/helpText.txt");
            }
        try {
            var helpTextStr = readFile("helpText.txt");
            }catch(e){
                var helpTextStr = null;
                }
        if(helpTextStr){helpTextAry = helpTextStr.split("&nextpage&");}
        helpTextAry[3] = "animationPATTERNS "+ versionNr + "\rMarkus Bergelt 2013\r\rhttp://aescripts.com/animationpatterns"; 
        var dimsHeaderBtn = [0,0,80,20];
        var dimsHelpText = [0,0,100,100];
        var dimsHelpText2 = [0,0,292,100];
        
        var helpDlg = createPalette(thisObj,"dialog",undefined); 
            helpDlg.orientation = "column";
            helpDlg.alignChildren = "left";
            helpDlg.margins = 5;
            helpDlg.spacing = 0;
        
        var grpHelpHeader= helpDlg.add("group", undefined, "HelpHeader");
            grpHelpHeader.orientation = "row";
            grpHelpHeader.alignChildren = "left";
            grpHelpHeader.margins = 0;
            grpHelpHeader.spacing = 0;
        
        var headerBtn1 = grpHelpHeader.add("button",dimsHeaderBtn,"palette");
        var headerBtn2 = grpHelpHeader.add("button",dimsHeaderBtn,"get started");
        var headerBtn3 = grpHelpHeader.add("button",dimsHeaderBtn,"go on");
        var headerBtn4 = grpHelpHeader.add("button",dimsHeaderBtn,"about");
        
        var grpHelpContent=  helpDlg.add("group", undefined, "HelpContent");
            grpHelpContent.orientation = "stack"; 
            grpHelpContent.alignChildren = "left";
            grpHelpContent.alignment = ["fill","fill"];
            grpHelpContent.margins = 0;
            grpHelpContent.spacing = 0;
        
        var helpText = grpHelpContent.add("EditText", undefined,helpTextAry[0],{multiline: true, scrolling: true});
            helpText.alignment = ["fill","fill"];
            helpText.visible = false;
            
        var grpHelpLayoutPage = grpHelpContent.add("group", undefined, "helpLayoutPage");
            grpHelpLayoutPage.orientation = "column"; 
            grpHelpLayoutPage.alignment = ["fill","fill"];
            grpHelpLayoutPage.alignChildren = "left";
            
        var grpHelpLayout = grpHelpLayoutPage.add("panel", undefined, "palette layout");
            grpHelpLayout.orientation = "row";
            grpHelpLayout.alignment = ["fill","top"];
            
        var grpHelpLayoutLeft = grpHelpLayout.add("group", undefined, "helpLayoutLeft");
            grpHelpLayoutLeft.orientation = "column";
            
        var grpHelpLayoutLeftUp = grpHelpLayoutLeft.add("group", undefined, "helpLayoutLeftUp");
        
        var grpHelpLayoutLeftDown = grpHelpLayoutLeft.add("group", undefined, "helpLayoutLeftDown");
            grpHelpLayoutLeftDown.orientation = "row";
            grpHelpLayoutLeftUp.add("dropdownlist", dimsAniPatternsList, ["(1)"]).selection = 0;
            grpHelpLayout.add("button",dimsCUBtn,"(2)");
            grpHelpLayoutLeftDown.add("button",dimsApplyBtn,"(3)");
            grpHelpLayoutLeftDown.add("button",dimsFindOutBtn,"(4)");
            
        var paletteLayoutText = grpHelpLayoutPage.add("EditText", undefined,helpTextAry[0],{multiline: true, scrolling: true});
            paletteLayoutText.alignment = ["fill","fill"];
            paletteLayoutText.preferredSize = [0,80];
        
        var grpHelpFooter= helpDlg.add("group", undefined, "HelpFooter");
            grpHelpFooter.orientation = "stack";
            grpHelpFooter.alignment = ["fill","bottom"];
            grpHelpFooter.margins = 0;
            grpHelpFooter.spacing = 0;
            
        var linkBtn = grpHelpFooter.add("button",dimsHeaderBtn,"video tutorial");
            linkBtn.alignment = "left";
            
        var closeBtn = grpHelpFooter.add("button",dimsHeaderBtn,"close");
            closeBtn.alignment = "right";
        
        helpDlg.onResize = helpDlg.onResizing = function () {this.layout.resize();}
        
        //reiter funktion ##########################################################################################
        headerBtn1.onClick = function() {
            helpText.visible = false;
            paletteLayoutText.text = helpTextAry[0];
            grpHelpLayoutPage.visible = true;
            }
        headerBtn2.onClick = function() {
            helpText.visible = true;helpText.text = helpTextAry[1];
            grpHelpLayoutPage.visible = false;
            }
        headerBtn3.onClick = function() {
            helpText.visible = true;helpText.text = helpTextAry[2];
            grpHelpLayoutPage.visible = false;
            }
        headerBtn4.onClick = function() {
            helpText.visible = true;helpText.text = helpTextAry[3];
            grpHelpLayoutPage.visible = false;
            }
        closeBtn.onClick = function() {
            helpDlg.close();
            }
        linkBtn.onClick = function() {
            var videoTutUrl = "http://aescripts.com/animationpatterns";
            if(isSecurityPrefSet()){
                openURL(videoTutUrl);
                }else{
                    alert("Can't open link: '" + videoTutUrl + "'\nplease allow scripts to write files and access network! (edit>preferences>general>)");
                    }
            }
        
        if (helpDlg instanceof Window){helpDlg.show();}else{helpDlg.layout.layout(true);helpDlg.layout.resize();}

        }

    // Palette erstellen ###########################################################################################
    {
        var palette = createPalette(thisObj,"palette",undefined); 
        palette.margins = 5;
        palette.orientation = "column";
        palette.alignChildren = "left";

        var paletteGfx = palette.graphics;

        var grpUI = palette.add("group", undefined, "rest");
        var grpHelp = palette.add("group", undefined, "help");
        grpUI.orientation = "row";
        var helpBtn = grpHelp.add("button",dimsHelpBtn,"?");
        helpBtn.helpTip = "a tool tip for a help button?\nno way man! ;)";
        
        var grpAniPattern = grpUI.add("group", undefined, "Animation Pattern");
        grpAniPattern.orientation = "column";
        grpAniPattern.alignChildren = "bottom";
        grpAniPattern.margins = 0;
        
        var aniPatternsList = grpAniPattern.add("dropdownlist", dimsAniPatternsList, aryAniPatternsList)
        aniPatternsList.selection = 0;
        aniPatternsList.helpTip = "choose an AnimationPattern";

        var grpButtons = grpAniPattern.add("group", undefined, "buttons");
        grpButtons.orientation = "row";
        
        var applyBtn = grpButtons.add("button",dimsApplyBtn,"apply Pattern");
        applyBtn.helpTip = "applies AnimationPattern \nto selected keyframe(s)";

        try {
            var findOutBtn = grpButtons.add("iconbutton",dimsFindOutBtn,"animationPATTERNS/icon_findOut.png");
            }catch(e){
                var findOutBtn = grpButtons.add("button",dimsFindOutBtn,"O-");
                }
        findOutBtn.helpTip = "shows AnimationPattern \nof selected keyframe";
        try {
            var createUpdateBtn = grpUI.add("iconbutton",dimsCUBtn,"animationPATTERNS/icon_createUpdate.png");
            }catch(e){
                var createUpdateBtn = grpUI.add("button",dimsCUBtn,"C'n'U");
                }
        createUpdateBtn.helpTip = "creates 'AnimationPatterns' layer \nupdates AnimationPattern-list";
        //createUpdateBtn.margins = [20,20,20,20];
        createUpdateBtn.alignment = "bottom";
        
        if (palette instanceof Window){palette.show();}else{palette.layout.layout(true);}
    }    
    
    // securitysetting prüfen, Vielen dank an Lloyd Alvarez!#######################################################
    function isSecurityPrefSet(){
			var securitySetting = app.preferences.getPrefAsLong("Main Pref Section",
							"Pref_SCRIPTING_FILE_NETWORK_SECURITY");
			return (securitySetting == 1);
		}    
    
    // hyperlinks aufrufen, Vielen dank an Lloyd Alvarez!#######################################################
	function openURL(url)  { // This function opens a URL in a browser 
		var winProgramFiles = Folder.commonFiles.parent.fsName;
		var winBrowserCmd = ($.os.indexOf("XP") != -1) ? "\"" + winProgramFiles + "\\Internet Explorer\\iexplore.exe\" " : "start ";  // start works great in windows 7 and Vista, very slow in win XP but works eventually.  
		//var macBrowserCmdStart = "osascript -e 'open location \""; //deprecated
		var macBrowserCmdStart = "open \"";
		var macBrowserCmdEnd = "\"";
         var command;
         try{
            if ($.os.indexOf("Windows") != -1){
                url =  url.replace(/&/g,'^&');  // replace & by ^&
               command = "cmd /c \""+winBrowserCmd + url+ "\"";
                system.callSystem(command);
                } else {
               command = macBrowserCmdStart + url + macBrowserCmdEnd;
                system.callSystem(command);
               }
            }catch(e){
                alert("Couldn't open link!\n"+e);
                }
		} 


    // Property Groups aus Array entfernen ###########################################################################################
    var removePrpertyGroup = function(selProps) {
        var temp = [];
        for(var f in selProps){
            if(!(selProps[f] instanceof PropertyGroup)){
                temp.push(selProps[f]);
                }
            }
        return temp;
        }

    // Pattern eines KFs lesen ###########################################################################################
    var getAniPatternFromSelKF = function(){
       try{     
            if(isValid(app.project.activeItem.layer("AnimationPatterns"))){
                var myPatterns = readPatternsInLayer();
                var numberPatterns = myPatterns.length;
                if(myPatterns){
                    updateAniPatternsList();
                    var aniPatternOfKey = [];
                    var keysInProps = [];
                    var propertyNames = [];
                    var propertyWithEaseBros = [];
                    var easeBros = [];                
                    var selProps = removePrpertyGroup(app.project.activeItem.selectedProperties);
                    for (var f in selProps){
                        var curProp = selProps[f];
                        if(curProp.canSetExpression){ 
                            if(curProp.expression.toString().substr(0,20) == "var diffPatterns = ["){
                                easeBros[f] = getOldPatterns (curProp);
                                }else{
                                    easeBros[f] = null;
                                    }  
                            }else{
                                easeBros[f] =null;
                                }
                        propertyNames[f] = curProp.name;
                        var keysInProp = curProp.selectedKeys;
                        keysInProps[f] = keysInProp;
                        }
                        if((keysInProps[0].length > 0) && (easeBros[0])){                
                            var selectedKey = keysInProps[0][0];
                            if(selectedKey > easeBros[0].length){
                                var patternOfKey = easeBros[0][easeBros[0].length-1];
                                }else{
                                    var patternOfKey = easeBros[0][selectedKey-1];
                                    }
                                if(patternOfKey>(numberPatterns-1)){patternOfKey=0;}
                                return patternOfKey; 
                            }else{
                                return 0;//alert("select a keyframe in a property that uses animationPATTERNS")
                                }
                    }
                }
           }catch(e){};
        }

    // Patterns für dropdown lesen ###########################################################################################
    var readPatternsInLayer = function(){
        try{
            if(isValid(app.project.activeItem.layer("AnimationPatterns"))){
                var patternLayer = app.project.activeItem.layer("AnimationPatterns");
                var myAniPatterns = ["- AE default -"];
                for(var i = 1; i <= patternLayer.property("ADBE Effect Parade").numProperties; ++i){
                    var myLayerProperty = patternLayer.property("ADBE Effect Parade").property(i);
                    myAniPatterns.push(myLayerProperty.name);
                    }
                return myAniPatterns
                }else{
                    alert("there is no 'AnimationPatterns' layer in this composition");
                    return null;
                    }
            }catch(e){return null;}
        }
    // DropDownUpdate ###########################################################################################
    var updateAniPatternsList = function(){
        try{
            if(isValid(aniPatternsList.selection)){var oldSelection = aniPatternsList.selection.index;}else{oldSelection = 0};
            var newlistItems = readPatternsInLayer();
            if(newlistItems != null){
                aniPatternsList.removeAll()
                for(var i = 0; i <= (newlistItems.length-1); ++i){
                    if(newlistItems[i].substr(0,3) == "---"){
                        aniPatternsList.add("separator",undefined,i);
                        }else{
                            aniPatternsList.add("item",newlistItems[i]);
                            }
                    }
                if(oldSelection > (newlistItems.length-1)){aniPatternsList.selection = 0;}else{aniPatternsList.selection = oldSelection;}
                }
            }catch(e){};
        }

    // Expression in gewählten Properties setzen ###########################################################################################
    var setExpression = function(expText, AniPattern) {
        var selProps = removePrpertyGroup(app.project.activeItem.selectedProperties);
          for (var f in selProps){
                var curProp = selProps[f];
                if (curProp.canSetExpression){ //sucht gewählte Properties
                    var curAniPatterns = [];
                    for(var i = 0; i <= (curProp.numKeys-1); ++i){ //geht KFs durch, erstellt Pattern Array
                        if(curProp.keySelected(i+1)){
                            curAniPatterns.push(AniPattern);
                            }else{
                                curAniPatterns.push(null);
                                }
                        }
                    try{    
                        if(curProp.numKeys > 0){
                            var oldAniPatterns = getOldPatterns(curProp);
                            }else{
                                oldAniPatterns = [0];
                                }
                            var newAniPatterns = includePatterns(oldAniPatterns,curAniPatterns);
                            expText = "var diffPatterns = [" + newAniPatterns.toString() + "]; \n"+ animationPATTERNSexp;                  
                            if(typeof curProp.value === "number" || curProp.value instanceof Array){
                                curProp.expression = expText;
                                }else{
                                    alert("sorry, animationPATTERNS does not work with: \n"+curProp.name);
                                    }
                        }catch(e){alert("can't apply expression! "+e)}
                    }else{alert("property doesn't support expressions: \n"+curProp.name);}
                }
        }

    // alten AniPattern Array holen ########################################################################################
    var getOldPatterns = function(curProp) {
        var expression = curProp.expression.toString();
        if(expression.substr(0,20) == "var diffPatterns = ["){
            for(var fLauf = 20; fLauf <= (expression.length-1); ++fLauf){
                if(expression.substr(fLauf,1) == "]"){var aryEnd = fLauf; fLauf = expression.length}
                }
            var patternsFromExpression = expression.substr(20,aryEnd-20).split(",");
            return patternsFromExpression
            }else{
                return [0,0];
                }
        }

    // PatternArray integrieren ###########################################################################################
    var includePatterns = function(oldAniPatterns,curAniPatterns){
        var newAniPatterns = [];
        for(var i = 0; i <= (curAniPatterns.length-1); ++i){
            if(curAniPatterns[i] != null){
                newAniPatterns.push(curAniPatterns[i]);
                }else{
                    if(i <= (oldAniPatterns.length-1)){
                        newAniPatterns.push(oldAniPatterns[i]);   
                        }else{
                            newAniPatterns.push(oldAniPatterns[oldAniPatterns.length-1]);
                            }
                    }
            }
        return newAniPatterns;
        }

    // Pfad feststellen ######################################################################
    function getPath(){
        var folderObj = new Folder((new File($.fileName)).path + "/animationPATTERNS");
        return folderObj;
        }

    // Quellfile auslesen ######################################################################
    function readFile(filename){
        var myFolderObj = getPath();
        var file_handle   = new File(myFolderObj.fsName + "/" + filename);
        if (!file_handle.exists){
            alert("I can't find this file: '" + filename + "'. \n\nI looked in here: '" + myFolderObj.fsName + "\n\nYou might haven't installed the animationPATTERNS-folder in your ScriptUI Panels directory?!\nanimationPATTERNS will not work!");
            return;
            }
        try{
            file_handle.open("r");
            var content = file_handle.read();
            }
            catch(e){
                alert("I couldn't read the animationPATTERNS expression file: " + e);
                return;
                }finally{
                    file_handle.close();
                    }
        return(content);
        }

    // AniPatternLayer erzeugen ##################################################################
    var createAniPatternsLayer = function(){
        var layerCreated = false;
        if(isValid(app.project.activeItem) && (app.project.activeItem instanceof CompItem)){
            var curComp = app.project.activeItem;
            //alert(curComp.layer(1).type.matchName);//ADBE AV layer
            if(!isValid(curComp.layer("AnimationPatterns"))){
                var myNewLayer = curComp.layers.addNull();
                myNewLayer.name = "AnimationPatterns";
                layerCreated = true;
                }else{
                    var myNewLayer = curComp.layer("AnimationPatterns");
                    }
                
            if(myNewLayer.property("ADBE Effect Parade").numProperties == 0){
                curComp.time = 0;
                var myFirstPattern = myNewLayer.property("ADBE Effect Parade").addProperty("ADBE Slider Control");
                myFirstPattern.name = "linear";
                myFirstPattern.property(1).setValueAtTime(0,0);
                myFirstPattern.property(1).setValueAtTime(4,100);
                try {
                    var presetFile = getFile("AniPatterns_default.ffx");
                    if(presetFile){
                        //bug in applyPreset... does apply to selected layer, not to myNewLayer.
                        for (var i = 1; i <= curComp.numLayers; i++){
                            curComp.layer(i).selected = false;
                            }
                        myNewLayer.selected = true;
                        myNewLayer.applyPreset(presetFile);
                        }
                    }catch(e){alert("couldn't apply default Animation Patterns");}
            }
            updateAniPatternsList();
            if(layerCreated){alert("'AnimationPatterns' layer in "+curComp.name+" created");}
            }else{
                alert("select a composition to put layer in");
                return null;
                }
        }

    // Animationsvorgabe laden ##################################################################
    var getFile = function(filename) {
        var myFolderObj = getPath();
        var file_handle   = new File(myFolderObj.fsName + "/" + filename);
        if (!file_handle.exists){
            alert("I can't find this file: '" + filename + "'. \n\nI looked in here: '" + myFolderObj.fsName + "\n\nYou might haven't installed the animationPATTERNS-folder in your ScriptUI Panels directory?!\nanimationPATTERNS will not work!");
            return null;
            }else{
                return file_handle;
                }
        }

    

    // Expression laden ###########################################################################################
    var animationPATTERNSexp = readFile("AniPatternsExpression.js");

    // Paletten funktionalität ###########################################################################################
    createUpdateBtn.onClick = function(){createAniPatternsLayer()}

    findOutBtn.onClick = function(){
        var myKFpattern = getAniPatternFromSelKF();
        if(myKFpattern != null){aniPatternsList.selection = myKFpattern;}
        }

    applyBtn.onClick = function(){
        if(isValid(app.project.activeItem) && (app.project.activeItem instanceof CompItem)){
            if(aniPatternsList.selection != null){
                app.beginUndoGroup("apply AnimationPattern");
                    var myChosenPattern = aniPatternsList.selection.index;
                    setExpression("100", myChosenPattern);
                app.endUndoGroup();
                }
            }
        }

    helpBtn.onClick = function(){
        helpMeOutDlg();
        }
}

mb_animationPatterns(this);
